


export class PhonePopup {
	
	tpl = `
	<div class="customer-phone-popup">
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				<a href="javascript:void(0);" [onclick]="widget.savePhone" class="fa fa-save"></a>
			</div>
			<h1>{{!phone.phoneId?'Nieuw telefoonnummer':'Bewerk telefoonnummer'}}</h1>
		</div>

		<form id="frmPhone">
			<ez-text name="phonenr" label="Telefoonnummer" [value]="phone.phonenr"></ez-text>
			
			<ez-text name="description" label="Omschrijving" [value]="phone.description"></ez-text>
		</form>
	</div>
	`;
	
	phone = {
		phoneId: null,
		phonenr: '',
		description: ''
	};
	
	container = null;
	
	callback_save = null;
	
	
	setPhone(p) {
		this.phone = p;
	}
	
	setCallbackSave( c ) { this.callback_save = c; }
	
	
	savePhone() {
		
		if (this.validate() > 0)
			return;
		
		this.phone.phonenr = $('#frmPhone input[name=phonenr]').val();
		this.phone.description = $('#frmPhone input[name=description]').val();
		
		if (this.callback_save) {
			this.callback_save( this.phone, this );
		}
		
		close_popup();
	}
	
	validate() {
		let errorCount = 0;
		$(this.container).find('span.error').text( '' );
		
		let pnr = $(this.container).find('input[name=phonenr]').val();
		pnr = $.trim( pnr );
		
		if (pnr.length < 3) {
			$('[name=phonenr] .error').text('minimaal 3 cijfers');
			errorCount++;
		}
		else if (!pnr.match(/\d+/)) {
			$('[name=phonenr] .error').text('bevat geen cijfers');
			errorCount++;
		}
		
		return errorCount;
	}
	
	
	close() {
		close_popup();
	}
	
	showPopup() {
		this.container = show_popup('Telefoonnummer', '');
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		ezTpl.setVar('phone', this.phone);
		ezTpl.setObject('widget', this);
		ezTpl.render();
		
		focusFirstField('#frmPhone');
	}
	
	
}

